<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiKeyAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $requestApikey = $request->header('X-API-KEY');

        $apiKey = Setting::where('key', 'api_key')->first();
        $apiKey = $apiKey != null ? $apiKey->value : null;

        if ($requestApikey && $apiKey != null && $requestApikey == $apiKey) {
            return $next($request);
        } else {
            return response()->json(
                [
                    'success' => false,
                    'message' => 'عدم اجازه دسترسی',
                    'code' => 401,
                ],
                401
            );
        }
    }
}
