<?php

namespace App\Http\Controllers\User\Financial;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class TransactionsController extends Controller
{
    /**
     * transaction list
     */
    public function index(Request $request)
    {
        /** user
         * @var App\Models\User $user
         */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $transactions = $user->transactions()->when($request->input('search'), function ($query, $search) {
            $query->where('transaction_id', 'like', "%{$search}%");
        })->when($request->input('accepted'), function ($query, $accepted) {
            if ($accepted) {
                $query->where('status', 'accepted');
            }
        })->when($request->input('rejected'), function ($query, $rejected) {
            if ($rejected) {
                $query->where('status', 'rejected');
            }
        })->when($request->input('deposit'), function ($query, $deposit) {
            if ($deposit) {
                $query->where('amount', '>', 0);
            }
        })->when($request->input('withdrawal'), function ($query, $withdrawal) {
            if ($withdrawal) {
                $query->where('amount', '<', 0);
            }
        })->orderBy('created_at', 'desc')->paginate(20)->through(fn($transaction) => [
            'id' => $transaction->id,
            'amount' => $transaction->amount,
            'transaction_id' => $transaction->transaction_id,
            'type' => $transaction->type,
            'get_formatted_amount' => $transaction->get_formatted_amount,
            'description' => $transaction->description,
            'status' => $transaction->status,
            'jalali_created_at' => $transaction->jalali_created_at,
        ]);
        $transactions->withQueryString();

        return Inertia::render('User/Financial/Transactions/List', [
            'transactions' => $transactions,
        ]);
    }
}
