<?php

namespace App\Http\Controllers\User\Comments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class CommentsController extends Controller
{
    /**
     * product comments list
     */
    public function index()
    {
        /** @var App\Models\User $user */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $productComments = $user->productComments()->orderBy('created_at', 'desc')->paginate(6)->through(fn($comment) => [
            'id' => $comment->id,
            'content' => $comment->content,
            'get_strengths' => $comment->get_strengths,
            'get_weakness' => $comment->get_weakness,
            'is_buyer' => $comment->is_buyer,
            'buy_suggest' => $comment->buy_suggest,
            'jalali_created_at' => $comment->jalali_created_at,
            'vote_up' => $comment->vote_up,
            'vote_down' => $comment->vote_down,
            'get_product_status' => $comment->get_product_status,
            'get_answer' => $comment->get_answer,

            'product' => [
                'id' => $comment->product->id,
                'title' => $comment->product->title,
                'slug' => $comment->product->slug,
            ],
            'user' => [
                'id' => $comment->user->id,
                'get_name' => $comment->user->get_name,
            ],
        ]);

        $productComments->withQueryString();

        return Inertia::render('User/Comments/List', [
            'product_comments' => $productComments
        ]);
    }
}
