<?php

namespace App\Http\Controllers\Store\Financial;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PendingPaymentsController extends Controller
{
    /**
     * pending payments list
     */
    public function index(Request $request)
    {
        /** user
         * @var App\Models\User $user
         */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $payments = $user->pendingPayments()->when($request->input('search'), function ($query, $search) {
            $query->whereHas('order', function ($q2) use ($search) {
                $q2->whereHas('consignments', function ($q3) use ($search) {
                    $q3->where('uuid', 'like', "%{$search}%");
                });
            });
        })->when($request->input('awaiting'), function ($query, $awaiting) {
            if ($awaiting) {
                $query->where('status', 'awaiting');
            }
        })->when($request->input('paid'), function ($query, $paid) {
            if ($paid) {
                $query->where('status', 'paid');
            }
        })->orderByRaw("FIELD(status , 'awaiting', 'paid') ASC")
            ->orderBy('created_at', 'desc')->paginate(20)->through(fn($payment) => [
                'id' => $payment->id,
                'amount' => $payment->amount,
                'type' => $payment->type,
                'status' => $payment->status,
                'jalali_paid_at' => $payment->jalali_paid_at,
                'jalali_created_at' => $payment->jalali_created_at,

                'order' => [
                    'id' => $payment->order->id,
                    'uuid' => $payment->order->uuid,
                ],
                'consignment' => $payment->type == 'seller' ? [
                    'id' => $payment->order->consignments()->where('store_id', $user->store->id)->first()->id,
                    'uuid' => $payment->order->consignments()->where('store_id', $user->store->id)->first()->uuid,
                ] : null,
                'user' => [
                    'id' => $payment->user->id,
                    'get_name' => $payment->user->get_name,
                    'type' => $payment->user->type,
                ],
            ]);
        $payments->withQueryString();

        return Inertia::render('Store/Financial/PendingPayments/List', [
            'payments' => $payments
        ]);
    }
}
