<?php

namespace App\Http\Controllers\Blog;

use App\Http\Controllers\Controller;
use App\Models\Template;
use App\Services\Blog\BlogService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class BlogController extends Controller
{
    /**
     * blog index page
     */
    public function index(Request $request, BlogService $blogService)
    {
        /** active template */
        $template = Template::where('status', 'active')->first();
        $seo = $blogService->seo();

        return Inertia::render('Blog/Index', [
            'components' => fn() => $blogService->getComponents($template),
            'seo' => $seo
        ])
            ->title($seo['title'])
            ->description($seo['description'] != null ? $seo['description'] : __('messages.sentence.not_completed'))
            ->tag('<link rel="canonical" href="' . urldecode(url()->full()) . '" />')
            ->ogMeta()
            ->ogUrl(urldecode(url()->full()))
            ->ogType('website')
            ->ogLocale('fa_IR')
            ->tag('<meta property="og:site_name" content="' . $seo['site_name'] . '" />')
            ->twitterSummaryCard()
            ->twitterSite($request->url())
            ->twitterCreator($seo['site_name'])
            ->tag('<script type="application/ld+json">' . $seo['schema'] . '</script>'); // schema
    }
}
