<?php

namespace App\Http\Controllers\Admin\WebService;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Illuminate\Support\Str;

class WebServiceController extends Controller
{
    /**
     * web service management
     */
    public function index()
    {
        $apiKey = Setting::where('key', 'api_key')->first();
        $apiKey = $apiKey != null ? $apiKey->value : null;

        return Inertia::render('Admin/WebService/Manage', [
            'apiKey' => $apiKey,
        ]);
    }

    /**
     * refresh api key
     */
    public function refresh_key(Request $request)
    {
        $newApiKey = Str::random(40);
        Setting::updateOrCreate(['key' => 'api_key'], [
            'value' => $newApiKey
        ]);

        return redirect()->back()->with('message', [__('messages.api_key_regenerated')]);
    }

    /**
     * delete api key
     */
    public function delete_key(Request $request)
    {
        $apiKey = Setting::where('key', 'api_key')->first();
        if ($apiKey != null) {
            $apiKey->delete();
        }

        return redirect()->back()->with('message', [__('messages.api_key_deleted')]);
    }
}
