<?php

namespace App\Http\Controllers\Admin\Reports;

use App\Http\Controllers\Controller;
use App\Models\Report;
use App\Services\Admin\Reports\ReportsService;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class ReportsController extends Controller
{
    /** show reports */
    public function index(Request $request, ReportsService $reportsService): Response
    {
        // delete all rows older than 60 days
        Report::whereDate('created_at', '<=', now()->subDay(60))->delete();

        return Inertia::render('Admin/Reports/List', [
            'reports' => $reportsService->getReports($request)
        ]);
    }
}
