<?php

namespace App\Http\Controllers\Admin\Products;

use App\Http\Controllers\Controller;
use App\Models\Question;
use App\Models\QuestionAnswer;
use App\Services\Admin\Products\ProductQuestionsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class QuestionsController extends Controller
{
    /******************** Questions *********************/
    /**
     * questions list
     */
    public function index(Request $request, ProductQuestionsService $productQuestionsService)
    {
        return Inertia::render('Admin/Products/Questions/QuestionList', [
            'questions' => $productQuestionsService->getQuestions($request)
        ]);
    }

    /**
     * accept question
     */
    public function question_accept(Question $question)
    {
        if ($question->status != 'awaiting')
            return redirect()->back();

        $question->update([
            'status' => 'publish',
        ]);

        /** Report Action */
        $this->report(__("messages.report_question_accepted"), 'product', $question->product);

        return redirect()->back()->with('message', [__('messages.question_accepted')]);
    }

    /**
     * delete question
     */
    public function question_delete(Question $question)
    {
        $question->delete();

        /** Report Action */
        $this->report(__("messages.report_question_deleted"), 'product', $question->product);

        return redirect()->back()->with('message', [__('messages.question_deleted')]);
    }

    /******************** Answers *********************/
    /**
     * accept answer
     */
    public function answer_accept(QuestionAnswer $answer)
    {
        if ($answer->status != 'awaiting')
            return redirect()->back();

        $answer->update([
            'status' => 'publish',
        ]);

        /** Report Action */
        $this->report(__("messages.report_question_answer_accepted"), 'product', $answer->question->product);

        return redirect()->back()->with('message', [__('messages.question_answer_accepted')]);
    }

    /**
     * send question answer
     */
    public function answer_send(Request $request, Question $question)
    {
        $request->validate([
            'answer' => 'required'
        ]);

        /** @var \App\Models\User $user */
        $user = auth()->user();

        $question->questionAnswers()->create([
            'user_id' => $user->id,
            'answer' => $request->answer,
            'status' => 'publish'
        ]);

        /** Report Action */
        $this->report(__("messages.report_question_answer_send"), 'product', $question->product);

        return redirect()->back()->with('message', [__('messages.question_answer_send')]);
    }

    /**
     * delete question answer
     */
    public function answer_delete(QuestionAnswer $answer)
    {
        $answer->delete();

        /** Report Action */
        $this->report(__("messages.report_question_answer_deleted"), 'product', $answer->question->product);

        return redirect()->back()->with('message', [__('messages.question_answer_deleted')]);
    }
}
