<?php

namespace App\Http\Controllers\Admin\Newsletters;

use App\Exports\NewsletterExport;
use App\Http\Controllers\Controller;
use App\Models\Newsletter;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Maatwebsite\Excel\Facades\Excel;

class NewslettersController extends Controller
{
    /**
     * show newsletters
     */
    public function index(Request $request)
    {
        /** @var LengthAwarePaginator */
        $newsletters = Newsletter::query()
            ->when($request->input('email'), function ($query, $email) {
                if ($email) {
                    $query->where('email', '!=', null);
                }
            })->when($request->input('phone'), function ($query, $phone) {
                if ($phone) {
                    $query->where('phone', '!=', null);
                }
            })->orderBy('created_at', 'desc')->paginate(20)->through(fn($newsletter) => [
                'id' => $newsletter->id,
                'value' => $newsletter->phone != null ? $newsletter->phone : $newsletter->email,
                'jalali_updated_at' => $newsletter->jalali_updated_at,
                'jalali_created_at' => $newsletter->jalali_created_at,
            ]);
        $newsletters->withQueryString();

        return Inertia::render('Admin/Newsletters/List', [
            'newsletters' => $newsletters,
        ]);
    }

    /**
     * destroy newsletter
     */
    public function destroy(Newsletter $newsletter)
    {
        $newsletter->delete();

        return redirect()->back()->with('message', [__('messages.newsletter_field_deleted')]);
    }

    /**
     * export storage
     */
    public function export(Request $request)
    {
        $request->validate([
            'type' => 'required'
        ]);

        /** Report Action */
        $this->report(__("messages.report_newsletters_exported"));

        return Excel::download(new NewsletterExport($request->type), ('خروجی خبرنامه - ' . ($request->type == 'phone' ? 'شماره همراه' : 'ایمیل')) . '.csv');
    }
}
