<?php

namespace App\Http\Controllers\Admin\Financial;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use App\Services\Admin\Financial\TransactionsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class TransactionsController extends Controller
{
    /**
     * transaction list
     */
    public function index(Request $request, TransactionsService $transactionsService)
    {
        return Inertia::render('Admin/Financial/Transactions/List', [
            'transactions' => $transactionsService->getTransactions($request),
        ]);
    }

    /**
     * sellers transaction list
     */
    public function sellers(Request $request, TransactionsService $transactionsService)
    {
        return Inertia::render('Admin/Financial/Transactions/Sellers', [
            'transactions' => $transactionsService->getSellerTransactions($request),
        ]);
    }

    /**
     * affiliates transaction list
     */
    public function affiliates(Request $request, TransactionsService $transactionsService)
    {


        return Inertia::render('Admin/Financial/Transactions/Affiliates', [
            'transactions' => $transactionsService->getAffiliateTransactions($request),
        ]);
    }
}
