<?php

namespace App\Http\Controllers\Admin\Financial;

use App\Helpers\CommonFunctionsHelper;
use App\Helpers\DropdownListHelper;
use App\Helpers\Places;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AddressRequest;
use App\Http\Requests\Admin\PaymentMetaRequest;
use App\Models\PaymentMeta;
use App\Models\Setting;
use App\Services\Admin\Financial\PaymentMetaService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PaymentMetaController extends Controller
{
    use CommonFunctionsHelper, Places, DropdownListHelper;

    /**
     * show payment meta settings
     */
    public function index(PaymentMetaService $paymentMetaService)
    {
        // init
        $paymentMetaService->initPaymentMeta();

        // get main payment meta
        $paymentMeta = PaymentMeta::where('store_id', null)->first();

        return Inertia::render('Admin/Financial/PaymentMeta/List', [
            'places' => $this->places(),
            'paymentMeta' => $paymentMeta,
        ]);
    }

    /**
     * update payment meta settings
     */
    public function update(PaymentMetaRequest $request)
    {
        $paymentMeta = PaymentMeta::where('store_id', null)->first();

        if ($paymentMeta != null) {
            $paymentMeta->update([
                'post_ways' => serialize($request->post_ways),
                'post_period' => null,
                'free_post_min_price' => $request->exists('free_post_min_price') && $request->free_post_min_price != null ? str_replace(',', '', $request->free_post_min_price) : 0,
            ]);
        }

        /** Report Action */
        $this->report(__("messages.report_payment_meta_edited"));

        return redirect()->back()->with('message', [__('messages.payment_meta_updated')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function address_store(AddressRequest $request)
    {
        $paymentMeta = PaymentMeta::where('store_id', null)->first();

        if ($paymentMeta != null) {
            $addresses = $paymentMeta->get_reception_centers_addresses;
            $addresses[$this->randStr(10)] = [
                'state' => $request->state,
                'city' => $request->city,
                'phone' => $request->phone,
                'postal_code' => $request->postal_code,
                'full_address' => $request->full_address,
                'location' => $request->location,
            ];

            $paymentMeta->update([
                'reception_centers_addresses' => serialize($addresses),
            ]);
        }

        /** Report Action */
        $this->report(__("messages.report_payment_meta_edited"));

        return redirect()->back()->with('message', [__('messages.address_created')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function address_update(AddressRequest $request, $id)
    {
        $paymentMeta = PaymentMeta::where('store_id', null)->first();

        if ($paymentMeta != null) {
            $addresses = $paymentMeta->get_reception_centers_addresses;
            $addresses[$id] = [
                'id' => $this->randStr(10),
                'state' => $request->state,
                'city' => $request->city,
                'phone' => $request->phone,
                'postal_code' => $request->postal_code,
                'full_address' => $request->full_address,
                'location' => $request->location,
            ];

            $paymentMeta->update([
                'reception_centers_addresses' => serialize($addresses),
            ]);
        }

        /** Report Action */
        $this->report(__("messages.report_payment_meta_edited"));

        return redirect()->back()->with('message', [__('messages.address_edited')]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function address_destroy(Request $request, $id)
    {
        $paymentMeta = PaymentMeta::where('store_id', null)->first();

        if ($paymentMeta != null) {
            $addresses = $paymentMeta->get_reception_centers_addresses;
            unset($addresses[$id]);

            $paymentMeta->update([
                'reception_centers_addresses' => serialize($addresses),
            ]);
        }

        /** Report Action */
        $this->report(__("messages.report_payment_meta_edited"));

        return redirect()->back()->with('message', [__('messages.address_deleted')]);
    }
}
