<?php

namespace App\Http\Controllers\Admin\Faq;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;
use Inertia\Inertia;

class FaqController extends Controller
{
    /**
     * faqs list
     */
    public function index()
    {
        return Inertia::render('Admin/Faq/List', [
            'faqs' => Faq::orderBy('created_at', 'desc')->get()
        ]);
    }

    /**
     * update faqs
     */
    public function update(Request $request)
    {
        $request->validate([
            'items' => ['required', 'array']
        ]);

        // delete all faqs
        Faq::query()->delete();

        // add updated faqs
        foreach ($request->items as $item) {
            Faq::create([
                'question' => $item['question'],
                'answer' => $item['answer'],
            ]);
        }

        return redirect()->back()->with('message', [__('messages.faqs_updated')]);
    }
}
