<?php

namespace App\Http\Controllers\Admin\Account;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class NotificationsController extends Controller
{
    public function index(): Response
    {
        /** @var App\Models\User $user */
        $user = auth()->user();

        // first: get notification list
        $notifications = $user->notifications()->latest()->paginate(20);

        // second: mark as read all notifications
        $user->unreadNotifications->markAsRead();

        return Inertia::render('Admin/Account/Notifications', [
            'notifications' => $notifications
        ]);
    }
}