<?php

namespace App\Helpers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

trait ThemeHelper
{
    /** theme mode */
    public function themeMode(Request $request): JsonResponse
    {
        $request->validate([
            'dark' => 'required'
        ]);

        // set theme
        Session::put('dark', $request->dark);

        return response()->json([
            'status' => true,
        ]);
    }

    /** site lang */
    public function locale(Request $request): JsonResponse
    {
        $request->validate([
            'locale' => 'required'
        ]);

        // set locale to session
        Session::put('locale', $request->locale);

        return response()->json([
            'status' => true,
        ]);
    }
}
