<?php

namespace App\Helpers;

use Illuminate\Http\Request;

trait CommonFunctionsHelper
{
    /** random string */
    public function randStr($length = 10)
    {
        $characters = 'abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /** get url protocol */
    public function protocol()
    {
        if (
            isset($_SERVER['HTTPS']) &&
            ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
            isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
            $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https'
        ) {
            return 'https://';
        } else {
            return 'http://';
        }
    }

    /** convert phone to international */
    public function convertToInternationalFormat($phone)
    {
        // اگر شماره با 0 شروع میشه، اون 0 رو حذف کن و +98 اضافه کن
        if (preg_match('/^0/', $phone)) {
            $phone = preg_replace('/^0/', '+98', $phone);
        }
        // اگر از قبل با +98 شروع شده باشه هم دست نزن
        elseif (!preg_match('/^\+98/', $phone)) {
            // برای هر حالت دیگه مثلا بدون 0 یا +98 می‌تونی اینجا اصلاح کنی
        }
        return $phone;
    }
}
